<?php
require_once __DIR__ . '/config.php';
if (session_status() === PHP_SESSION_NONE) session_start();
$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $password = $_POST['password'] ?? '';
  $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
  $stmt->execute([$username]);
  $user = $stmt->fetch();
  if ($user && password_verify($password, $user['password_hash'])) {
    $_SESSION['user'] = ['id'=>$user['id'], 'username'=>$user['username']];
    header('Location: /dashboard.php'); exit;
  } else { $error = "Invalid username or password."; }
}
?><!doctype html><html lang="en"><head><meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Login – Infotronics</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"/></head>
<body class="bg-light"><div class="container py-5"><div class="row justify-content-center"><div class="col-md-4">
<div class="card shadow-sm"><div class="card-body">
<h1 class="h5 mb-3">Sign in</h1><?php if($error): ?><div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
<form method="post"><div class="mb-3"><label class="form-label">Username</label><input class="form-control" name="username" required></div>
<div class="mb-3"><label class="form-label">Password</label><input type="password" class="form-control" name="password" required></div>
<div class="d-grid"><button class="btn btn-primary" type="submit">Login</button></div></form>
<div class="mt-3"><a href="/forgot_password.php">Forgot password?</a></div>
</div></div></div></div></div></body></html>
