<?php
require_once __DIR__ . '/includes/auth.php'; require_login();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = intval($_POST['id'] ?? 0);
  $name = trim($_POST['name'] ?? '');
  $address = trim($_POST['address'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $website = trim($_POST['website'] ?? '');
  if ($name && $address && $email) {
    if ($id) { $stmt = $pdo->prepare("UPDATE clients SET name=?, address=?, phone=?, email=?, website=? WHERE id=?"); $stmt->execute([$name,$address,$phone,$email,$website,$id]); }
    else { $stmt = $pdo->prepare("INSERT INTO clients (name,address,phone,email,website,created_by_user_id) VALUES (?,?,?,?,?,?)"); $stmt->execute([$name,$address,$phone,$email,$website,current_user_id()]); }
  }
  header('Location: /clients.php'); exit;
}
if (isset($_GET['del'])) { $pdo->prepare("DELETE FROM clients WHERE id=?")->execute([intval($_GET['del'])]); header('Location: /clients.php'); exit; }
$rows = $pdo->query("SELECT c.*, u.username as created_by FROM clients c LEFT JOIN users u ON u.id=c.created_by_user_id ORDER BY c.id DESC")->fetchAll();
include __DIR__ . '/includes/header.php';
?>
<h1 class="h5">Clients</h1>
<div class="card mb-3"><div class="card-body">
<form method="post" class="row g-3">
  <input type="hidden" name="id">
  <div class="col-md-4"><label class="form-label">Client Name *</label><input class="form-control" name="name" required></div>
  <div class="col-md-8"><label class="form-label">Address *</label><input class="form-control" name="address" required></div>
  <div class="col-md-3"><label class="form-label">Phone</label><input class="form-control" name="phone"></div>
  <div class="col-md-3"><label class="form-label">Email *</label><input type="email" class="form-control" name="email" required></div>
  <div class="col-md-3"><label class="form-label">Website</label><input class="form-control" name="website"></div>
  <div class="col-md-3 d-grid align-self-end"><button class="btn btn-primary" type="submit">Save</button></div>
</form>
</div></div>
<div class="card"><div class="card-body">
<table class="table table-striped align-middle"><thead><tr><th>#</th><th>Name</th><th>Address</th><th>Phone</th><th>Email</th><th>Website</th><th>Created By</th><th>Action</th></tr></thead><tbody>
<?php $i=1; foreach($rows as $r): ?><tr>
<td><?php echo $i++; ?></td><td><?php echo htmlspecialchars($r['name']); ?></td><td><?php echo htmlspecialchars($r['address']); ?></td>
<td><?php echo htmlspecialchars($r['phone']); ?></td><td><?php echo htmlspecialchars($r['email']); ?></td><td><?php echo htmlspecialchars($r['website']); ?></td>
<td><?php echo htmlspecialchars($r['created_by']); ?></td>
<td><a class="btn btn-sm btn-outline-danger" href="/clients.php?del=<?php echo $r['id']; ?>" onclick="return confirm('Delete?')">Delete</a></td>
</tr><?php endforeach; ?>
</tbody></table>
</div></div>
<?php include __DIR__ . '/includes/footer.php'; ?>
