<?php
require_once __DIR__ . '/includes/auth.php'; require_login();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = intval($_POST['id'] ?? 0); $name = trim($_POST['name'] ?? '');
  if ($name) { if ($id) { $pdo->prepare("UPDATE subscriptions SET name=? WHERE id=?")->execute([$name,$id]); } else { $pdo->prepare("INSERT INTO subscriptions (name, created_by_user_id) VALUES (?,?)")->execute([$name, current_user_id()]); } }
  header('Location: /subscription.php'); exit;
}
if (isset($_GET['del'])) { $pdo->prepare("DELETE FROM subscriptions WHERE id=?")->execute([intval($_GET['del'])]); header('Location: /subscription.php'); exit; }
$rows = $pdo->query("SELECT s.*, u.username created_by FROM subscriptions s LEFT JOIN users u ON u.id=s.created_by_user_id ORDER BY s.name")->fetchAll();
include __DIR__ . '/includes/header.php'; ?>
<h1 class="h5">Subscription (Master)</h1>
<div class="card mb-3"><div class="card-body">
<form method="post" class="row g-3">
  <input type="hidden" name="id"><div class="col-md-6"><label class="form-label">Subscription *</label><input class="form-control" name="name" required></div>
  <div class="col-md-3 d-grid align-self-end"><button class="btn btn-primary" type="submit">Save</button></div>
</form></div></div>
<div class="card"><div class="card-body">
<table class="table table-striped align-middle"><thead><tr><th>#</th><th>Subscription</th><th>Created By</th><th>Action</th></tr></thead><tbody>
<?php $i=1; foreach($rows as $r): ?><tr><td><?php echo $i++; ?></td><td><?php echo htmlspecialchars($r['name']); ?></td><td><?php echo htmlspecialchars($r['created_by']); ?></td>
<td><a class="btn btn-sm btn-outline-danger" href="/subscription.php?del=<?php echo $r['id']; ?>" onclick="return confirm('Delete?')">Delete</a></td></tr><?php endforeach; ?>
</tbody></table></div></div>
<?php include __DIR__ . '/includes/footer.php'; ?>
