<?php
$DB_HOST = getenv('DB_HOST') ?: 'localhost';
$DB_NAME = getenv('DB_NAME') ?: 'sub_memo';
$DB_USER = getenv('DB_USER') ?: 'root';
$DB_PASS = getenv('DB_PASS') ?: '';

$MYSQL_SSL_CA   = getenv('MYSQL_SSL_CA') ?: null;
$MYSQL_SSL_CERT = getenv('MYSQL_SSL_CERT') ?: null;
$MYSQL_SSL_KEY  = getenv('MYSQL_SSL_KEY') ?: null;

try {
    $dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    $pdo = new PDO($dsn, $DB_USER, $DB_PASS, $options);
    if ($MYSQL_SSL_CA)   $pdo->setAttribute(PDO::MYSQL_ATTR_SSL_CA, $MYSQL_SSL_CA);
    if ($MYSQL_SSL_CERT) $pdo->setAttribute(PDO::MYSQL_ATTR_SSL_CERT, $MYSQL_SSL_CERT);
    if ($MYSQL_SSL_KEY)  $pdo->setAttribute(PDO::MYSQL_ATTR_SSL_KEY, $MYSQL_SSL_KEY);
} catch (Exception $e) {
    http_response_code(500);
    echo "DB connection error.";
    exit;
}

// SMTP (Office 365)
$SMTP_HOST = 'smtp.office365.com';
$SMTP_PORT = 587;
$SMTP_USER = 'admin@infotronicsindia.com';
$SMTP_PASS = '6l7BZO]z4R(g';
$SMTP_FROM_EMAIL = 'admin@infotronicsindia.com';
$SMTP_FROM_NAME  = 'Infotronics Admin';
?>
